#!/bin/sh
# -----------------------------------------------------------------------------
# Control WIP Node
#
# Copyright: © 2015-2023 Claris International Inc. All rights reserved.
#
# Environment Variable Prerequisites
#
#   ARGS     start, stop.
#
# -----------------------------------------------------------------------------

# FileMaker WIPNODE Settings
export NODE_ENV=production
WIPNODE_BASE=$(dirname "$0")
case "$(uname -s)" in
	Darwin)
		INSTALL_ROOT="/Library/FileMaker Server"
		;;
	Linux)
		INSTALL_ROOT="/opt/FileMaker/FileMaker Server"
 		;;
esac

NODE_PATH="$INSTALL_ROOT/node/bin/node"
WIP_NODE_DIR="$INSTALL_ROOT/Web Publishing/publishing-engine/node-wip"
WIP_NODEJS="$WIP_NODE_DIR/app.js"

WIP_COMP="DFMS.COMPONENT=wipn"
WIPNODE_PID=""

if [ "$1" = "start" ] ; then
  echo "Starting WIP node"
  shift

  if [ "$1" = "-p" ]; then
    shift
    WIPNODE_BASE=$1
  fi

  echo "Execute node JS $NODE_PATH $WIP_NODEJS"
  "$NODE_PATH" "$WIP_NODEJS" "-$WIP_COMP"

elif [ "$1" = "stop" ] ; then
  echo "Stopping WIP node"

  shift
  FORCE=0
  if [ "$1" = "-force" ]; then
    shift
    FORCE=1
  fi

  if [ "$1" = "-z" ]; then
    shift
    WIPNODE_PID=$1
  fi
  # we don't pass pid, can we assume we are kill all node

# check if WIPNODE_PID exists and is node. to make sure we don't kill random process
# we can specify to send specific custom signal like SIGFMND (signal FM node) function
# and we can call kill $WIPNODE_PID

# echo "$WIPNODE_PID"
  if [ "$WIPNODE_PID" = "" ]; then
    echo "No WIP node running!"
    # do nothing, because we assume this its already killed
  else

   # WIP_PID_EXIST=$(ps $WIPNODE_PID | grep $WIP_COMP )
   WIP_PID_EXIST=$(ps -p $WIPNODE_PID -o comm= | awk '{print $1}')
   
  if [ "$WIP_PID_EXIST" = "node" ]; then

     # force kill
    if [ $FORCE -eq 1 ]; then
      echo "Killing with force: $WIPNODE_PID"
      kill -USR1 $WIPNODE_PID

    else
      echo "Killing: $WIPNODE_PID"
      kill $WIPNODE_PID
    fi
  else
    echo "PID $WIPNODE_PID is not running or is not 'WIP node'"
  fi

  fi

else

  echo "Usage: wipdeploy.sh ( commands ... )"
  echo "commands:"
  echo "  start               Start WIP node in a separate window"
  echo "  stop  -z PID        Stop WIP node with process id = PID"
  echo "  stop -force -z PID  Stop WIP node with process id = PID forcefully"
  exit 1

fi
exit 0
